
// NvidiaEncoder.cpp : implementation file
//

#include "stdafx.h"
#include "NvidiaEncoder.h"
#include "NvidiaEncoderDlg.h"
#include "afxdialogex.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

BYTE * g_p_video_frame_buffer_background = NULL;

ULONG  g_n_video_frame_length_background = 0;

VOID DumpDebugMessage( CHAR * fmt, ... )
{
	CHAR pszDebugDumpMessage[ MAX_PATH ] = "[DEBUG] ";
	
	va_list marker;

	va_start( marker, fmt);

	vsprintf( pszDebugDumpMessage + 8, fmt, marker );

	va_end( marker );

	strcat( pszDebugDumpMessage, "\n" );

	OutputDebugString( pszDebugDumpMessage );
}

DWORD WINAPI on_push_video_framebuffer( LPVOID params )
{
	CNvidiaEncoderDlg *  pMainDialog = (CNvidiaEncoderDlg *)(params);

	while ( TRUE && pMainDialog->m_bSetBuffer )
    {
		DWORD dwWaitResult = 0x00000000;

		dwWaitResult = WaitForSingleObject( pMainDialog->m_hVideoThreadBufferReadyEvent, INFINITE );		

		if( dwWaitResult == WAIT_OBJECT_0 )
		{
			EnterCriticalSection( &pMainDialog->m_hAccessFileCriticalSection );

			if ( g_p_video_frame_buffer_background != NULL && g_n_video_frame_length_background > 0 )
			{
				BOOL bIsRecord = (pMainDialog->m_nFileRendererRecordState >= 0x00000002) ? TRUE : FALSE;

				if ( pMainDialog->m_hVideoNvidiaEncoderDev != 0xFFFFFFFF )
				{
					BYTE * pStreamBuffer = NULL;

					ULONG  nStreamBufferLen = 0;

					BOOL   bIsKeyFrame = FALSE;

					AMESDK_RUN( pMainDialog->m_hVideoNvidiaEncoderDev ); // PUT THE ENCODER INTO RUNNING STATE

					AMESDK_CODEC_ENCODE( pMainDialog->m_hVideoNvidiaEncoderDev, g_p_video_frame_buffer_background, PREVIEW_COLORSPACE,  WIDTH, HEIGHT, &pStreamBuffer, &nStreamBufferLen, &bIsKeyFrame );

					if( bIsKeyFrame ) 
					{ 
						pMainDialog->m_nFileRendererRecordState = 0x00000002;

						bIsRecord = TRUE;
					}

					if( bIsRecord && nStreamBufferLen > 0 ) 
					{
						if ( pMainDialog->m_pBinFile != NULL )
						{
							pMainDialog->m_pBinFile->Write( pStreamBuffer, nStreamBufferLen );
						}

						if ( pMainDialog->m_pTxtFile != NULL )
						{
							CString strTxt;

							strTxt.Format( "%d,%d\n", nStreamBufferLen, ( bIsKeyFrame ) ? 1: 0 );

							pMainDialog->m_pTxtFile->WriteString( strTxt );
						}					
					}
				}
			}

			LeaveCriticalSection( &pMainDialog->m_hAccessFileCriticalSection );
		}
	}

	return 0;
}

BOOL on_process_preview_video_buffer( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{
	CNvidiaEncoderDlg *  pMainDialog = (CNvidiaEncoderDlg *)(pUserData);
	
	if ( pBuffer != NULL && nBufferLen > 0 )
	{
		g_p_video_frame_buffer_background = pBuffer;

		g_n_video_frame_length_background = nBufferLen;		

		if(  pMainDialog->m_hVideoThreadBufferReadyEvent )
		{
			SetEvent( pMainDialog->m_hVideoThreadBufferReadyEvent );
		}		
	}

	return TRUE;
}

// CNvidiaEncoderDlg dialog


CNvidiaEncoderDlg::CNvidiaEncoderDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(CNvidiaEncoderDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	m_hVideoDev = 0xFFFFFFFF;		
	
	m_hVideoNvidiaEncoderDev = 0xFFFFFFFF;

	m_nFileRendererRecordState = 0x00000000;

	m_hVideoThreadBufferReadyEvent = NULL;

	m_hVideoThread = NULL;	

	m_hVideoThreadNumber = 0;

	m_bSetBuffer = FALSE;

	m_pTxtFile = NULL;

	m_pBinFile = NULL;
}

void CNvidiaEncoderDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CNvidiaEncoderDlg)
	DDX_Control(pDX, IDC_STATIC_WINDOW, m_statWindow);
	DDX_Control(pDX, IDC_BTN_START, m_btnStart);
	DDX_Control(pDX, IDC_BTN_STOP, m_btnStop);
	//}}AFX_DATA_MAP	
}

BEGIN_MESSAGE_MAP(CNvidiaEncoderDlg, CDialogEx)
	//{{AFX_MSG_MAP(CNvidiaEncoderDlg)
	ON_WM_PAINT()
	ON_WM_DESTROY()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_BTN_START, &CNvidiaEncoderDlg::OnBnClickedBtnStart)
	ON_BN_CLICKED(IDC_BTN_STOP, &CNvidiaEncoderDlg::OnBnClickedBtnStop)
END_MESSAGE_MAP()


// CNvidiaEncoderDlg message handlers

BOOL CNvidiaEncoderDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here

	// INITIALIZE COM RESOURCE
	//
	HRESULT hr = CoInitialize( NULL );

	CenterWindow();

	CString strCaption;

	strCaption.Format( "Yuan's %s Demo Software - H.265 Nvidia NvEnc Encoder", PRODUCT_NAME );

	SetWindowText( strCaption );

	InitializeCriticalSection( &m_hAccessFileCriticalSection );

	HwInitialize();

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CNvidiaEncoderDlg::OnDestroy() 
{
	OnBnClickedBtnStop();

	HwUnInitialize();

	DeleteCriticalSection( &m_hAccessFileCriticalSection );

	// UNINITIALIZE COM RESOURCE
	//
	CoUninitialize();
}

BOOL CNvidiaEncoderDlg::HwInitialize()
{
	PF_BUFFER_CALLBACK pfVideoPreviewBC = NULL;

	pfVideoPreviewBC = on_process_preview_video_buffer;

	CWnd *pPreviewWnd = GetDlgItem( IDC_STATIC_WINDOW );

	m_hVideoDev = AMESDK_CREATE( CHIP_NAME, 0, 0, pPreviewWnd->GetSafeHwnd(), pfVideoPreviewBC, (PVOID)this );

	if( m_hVideoDev & 0x80000000 ) 
	{ 
		m_hVideoDev = 0xFFFFFFFF; 

		return FALSE; 		
	}

	// SETUP LIVE PATH PROPERTIES
	// 		
	AMESDK_SET_STANDARD( m_hVideoDev, NTSC );
	
	AMESDK_SET_FORMAT( m_hVideoDev, PREVIEW_COLORSPACE, WIDTH, HEIGHT, PREVIEW_BIT_COUNT, FPS );

	AMESDK_SET_INPUT( m_hVideoDev, SDI_INPUT );

	m_hVideoNvidiaEncoderDev = AMESDK_CREATE( "Common Analog Nvidia NvEnc Encoder (H.265)", 0, 7, NULL, NULL, NULL );
		
	if( m_hVideoNvidiaEncoderDev & 0x80000000 ) 
	{ 
		m_hVideoNvidiaEncoderDev = 0xFFFFFFFF; 

		return FALSE; 	
	}

	// SETUP SOFTWARE ENCODER PROPERTIES
	//
	AMESDK_SET_FORMAT( m_hVideoNvidiaEncoderDev, ENCODER_COLORSPACE, WIDTH, HEIGHT, ENCODER_BIT_COUNT, FPS, ENCODER_MODE, ENCODER_BITRATE, ENCODER_QUALITY, ENCODER_GOP,  FALSE, 0 ); // RESOLUTION / FRAMERATE / RECORD MODE / BITRATE (CBR) / QULAITY (VBR) / GOP / INTERLACE MODE

	AMESDK_RUN( m_hVideoDev );

	AMESDK_RUN( m_hVideoNvidiaEncoderDev );

	m_hVideoThreadBufferReadyEvent = CreateEvent( NULL, FALSE, FALSE, NULL );		

	m_bSetBuffer = TRUE;

	m_hVideoThread = CreateThread( NULL, 0, (LPTHREAD_START_ROUTINE)( on_push_video_framebuffer ), (LPVOID)(this), 0, &m_hVideoThreadNumber );	

	return TRUE;
}

BOOL CNvidiaEncoderDlg::HwUnInitialize()
{
	m_bSetBuffer = FALSE;

	Sleep( 100 );

	if ( m_hVideoThreadBufferReadyEvent )
	{
		ResetEvent( m_hVideoThreadBufferReadyEvent );

		CloseHandle( m_hVideoThreadBufferReadyEvent );	

		m_hVideoThreadBufferReadyEvent = NULL;
	}

	if( m_hVideoDev != 0xFFFFFFFF ) 
	{ 
		AMESDK_STOP( m_hVideoDev );

		AMESDK_DESTROY( m_hVideoDev );
		
		m_hVideoDev = 0xFFFFFFFF; 
	}

	if( m_hVideoNvidiaEncoderDev != 0xFFFFFFFF ) 
	{
		AMESDK_DESTROY( m_hVideoNvidiaEncoderDev );
		
		m_hVideoNvidiaEncoderDev = 0xFFFFFFFF; 
	}		

	return TRUE;
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CNvidiaEncoderDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CNvidiaEncoderDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

CString CNvidiaEncoderDlg::GetWorkingPath()
{
	TCHAR szCurPath[MAX_PATH] = {0};

	GetModuleFileName(NULL, szCurPath, MAX_PATH);

	CString strCurPath = szCurPath;

	strCurPath = strCurPath.Left(strCurPath.ReverseFind('\\') + 1);

	return strCurPath;
}

void CNvidiaEncoderDlg::OnBnClickedBtnStart()
{
	// TODO: Add your control notification handler code here

	m_btnStart.EnableWindow( FALSE );

	m_btnStop.EnableWindow( TRUE );

	m_pTxtFile = NULL;

	m_pBinFile = NULL;

	CHAR pszTxtFile[ MAX_PATH ];

	CHAR pszBinFile[ MAX_PATH ];

	sprintf( pszTxtFile, "%sNVIDIA_NVENC_H265_%d_%d_%.2f.TXT", GetWorkingPath(), WIDTH, HEIGHT, FPS );

	sprintf( pszBinFile, "%sNVIDIA_NVENC_H265_%d_%d_%.2f.H265", GetWorkingPath(), WIDTH, HEIGHT, FPS );

	m_pTxtFile = new CStdioFile( pszTxtFile,  CFile::modeCreate | CFile::modeWrite | CFile::typeText );	

	m_pBinFile = new CStdioFile( pszBinFile,  CFile::modeCreate | CFile::modeWrite | CFile::typeBinary );

	m_nFileRendererRecordState = 0x00000001;
}


void CNvidiaEncoderDlg::OnBnClickedBtnStop()
{
	// TODO: Add your control notification handler code here

	m_btnStart.EnableWindow( TRUE );

	m_btnStop.EnableWindow( FALSE );

	EnterCriticalSection( &m_hAccessFileCriticalSection );

	m_nFileRendererRecordState = 0x00000000;
	
	LeaveCriticalSection( &m_hAccessFileCriticalSection );

	if ( m_pTxtFile != NULL )
	{
		m_pTxtFile->Close();

		delete m_pTxtFile;

		m_pTxtFile = NULL;
	}

	if ( m_pBinFile != NULL )
	{
		m_pBinFile->Close();

		delete m_pBinFile;

		m_pBinFile = NULL;
	}
}
